/* jbmMidiFileInfo - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package jbmMidiParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

import com.cycling74.max.Atom;
import com.cycling74.max.MaxObject;

public class jbmMidiFileInfo extends MaxObject
{
    private static String sourceWork;
    public TreeMap completeSequence;
    private jbmMidiParser midiParser;
    
    public jbmMidiFileInfo() {
	zap();
	completeSequence = new TreeMap();
    }
    
    public void read(String midifile) {
	String temp = "";
	StringTokenizer st = new StringTokenizer(midifile, "/");
	while (st.hasMoreTokens())
	    temp = st.nextToken();
	StringTokenizer st2 = new StringTokenizer(temp, ".");
	sourceWork = st2.nextToken();
	midiParser = new jbmMidiParser();
	completeSequence = midiParser.parseMidiFile(midifile);
    }
    
    public void dumpTrackEvents(int track) {
	ArrayList events = new ArrayList();
	Integer trackNum = new Integer(track);
	if (completeSequence.containsKey(trackNum))
	    events = (ArrayList) completeSequence.get(trackNum);
	for (int i = 0; i < events.size(); i++) {
	    Atom[] event = (Atom[]) events.get(i);
	    outlet(0, event);
	}
    }
    
    public void dump() {
	ArrayList events = new ArrayList();
	Set keys = completeSequence.keySet();
	Iterator itr = keys.iterator();
	while (itr.hasNext()) {
	    Integer trackNum = (Integer) itr.next();
	    if (trackNum.intValue() < 200
		&& completeSequence.containsKey(trackNum)) {
		events = (ArrayList) completeSequence.get(trackNum);
		for (int i = 0; i < events.size(); i++) {
		    Atom[] event = (Atom[]) events.get(i);
		    if (midiParser.getBuildForRB())
			outlet(0, event);
		    else
			outlet(0, reformat((Atom[]) events.get(i)));
		}
	    }
	}
    }
    
    private Atom[] reformat(Atom[] input) {
	int res = input[2].getInt();
	long tick = input[1].toLong();
	double fractionalTick = 0.0;
	int duration = input[10].getInt();
	float floatBeat = (float) duration / (float) res;
	if (res > 0)
	    fractionalTick = (double) (tick % (long) res) / (double) res;
	Atom tickOut = Atom.newAtom(fractionalTick);
	Atom[] reformatted = null;
	if (input[15].getInt() >= 176 && input[15].getInt() < 192
	    || input[15].getInt() >= 224 && input[15].getInt() < 240)
	    reformatted
		= new Atom[] { input[12], input[0], input[16], input[17],
			       tickOut, input[15], input[10], input[11],
			       input[8], tickOut };
	else if (midiParser.getBuildForRB())
	    reformatted = new Atom[] { input[14], input[0], input[5], input[6],
				       input[1], input[17], input[6], input[7],
				       input[8] };
	else
	    reformatted
		= new Atom[] { input[14], input[0], input[5], input[6],
			       Atom.newAtom((float) fractionalTick), input[17],
			       input[6], input[7], Atom.newAtom(floatBeat) };
	return reformatted;
    }
    
    private void reportLengthInBars() {
	ArrayList events = new ArrayList();
	Set keys = completeSequence.keySet();
	long highTick = 0L;
	Atom[] lastEvent = new Atom[17];
	Iterator itr = keys.iterator();
	while (itr.hasNext()) {
	    Integer trackNum = (Integer) itr.next();
	    if (completeSequence.containsKey(trackNum)
		&& trackNum.intValue() < 998) {
		events = (ArrayList) completeSequence.get(trackNum);
		for (int i = 0; i < events.size(); i++) {
		    Atom[] event = (Atom[]) events.get(i);
		    long tickstamp = event[0].toLong();
		    if (tickstamp > highTick) {
			highTick = tickstamp;
			lastEvent = event;
		    }
		}
	    }
	}
	int bar = lastEvent[16].getInt();
	outlet(1, bar);
    }
    
    public jbmMidiParser getMidiParser() {
	return midiParser;
    }
    
    public void setMidiParser(jbmMidiParser midiParser) {
	this.midiParser = midiParser;
    }
}
